import os
from pathlib import Path

BASE_DIR = Path(__file__).resolve().parent.parent

# Generate a new secret key and replace this:
SECRET_KEY = 'django-insecure-your-new-50-character-secret-key-here'  # REPLACE THIS!

DEBUG = False  # Change to False

# Add your actual domain
ALLOWED_HOSTS = [
    'taiyadetergents.co.ke',
    'www.taiyadetergents.co.ke',
    'localhost',
    '127.0.0.1',
]

# Security settings - enable all
SECURE_SSL_REDIRECT = True
CSRF_COOKIE_SECURE = True
SESSION_COOKIE_SECURE = True
SECURE_BROWSER_XSS_FILTER = True
SECURE_CONTENT_TYPE_NOSNIFF = True
X_FRAME_OPTIONS = 'DENY'

# Keep your existing static files configuration
STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, 'staticfiles')
STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'static'),
]

MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')

# Database - use SQLite for now
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}