from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static

# Customize Django Admin Interface
admin.site.site_header = 'TAIYA ADMIN'
admin.site.site_title = 'TAIYA ADMIN'
admin.site.index_title = 'Welcome to Taiya Detergents Administration'

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', include('store.urls')),
]

# Only add media serving in development mode
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)